
******************************************************************
*
* PANEL-ANALYSIS (example from Kohler/Kreuter 2009)
*
* JOSEF BRÜDERL, UNIVERSITY OF MUNICH, April 2019
*
******************************************************************

use "C:\Users\bruederl\LRZ Sync+Share\Vorlesung PDA\Stata Beispiele\Artificial Data\Beatles.dta"


* The data
separate lsat, by(persnr)
twoway  (scatter lsat1-lsat4 age, msymbol(O O O O) msize(large large large large) mcolor(blue green orange brown)),  ///
        ylabel(0(2)10,  labsize(medlarge) grid angle(0))    ///
		xlabel(25(1)30, labsize(medlarge))                  /// 
		xtitle(Age in Years, size(large) margin(medsmall))  ///
		ytitle(Satisfaction, size(large)) ///
        legend(order(3 "George" 2 "Paul" 1 "John" 4 "Ringo") pos(11) ring(0)) 


* POLS
regress lsat age
twoway  (scatter lsat age, msymbol(O) msize(large) mcolor(blue))         ///
        (lfit lsat age, lwidth(thick) lcolor(red)),                     ///
        ylabel(0(2)10,  labsize(medlarge) grid angle(0))    ///
		xlabel(25(1)30, labsize(medlarge))                  /// 
		xtitle(Age in Years, size(large) margin(medsmall))  ///
		ytitle(Satisfaction, size(large))                   ///
        legend(off) 
		
		

* FE Estimator
regress lsat age i.persnr
predict  yhat
separate yhat, by(persnr)
twoway  (scatter lsat1-lsat4 age, msymbol(O O O O) msize(large large large large) mcolor(blue green orange brown))  ///
        (line    yhat1-yhat4 age, lwidth(thick thick thick thick) lcolor(blue green orange brown))                  ///
        (lfit lsat age, lwidth(medthick) lcolor(red)),      ///
        ylabel(0(2)10,  labsize(medlarge) grid angle(0))    ///
		xlabel(25(1)30, labsize(medlarge))                  /// 
		xtitle(Age in Years, size(large) margin(medsmall))  ///
		ytitle(Satisfaction, size(large))                   ///
        legend(off) 

		
* Person specific regression lines
drop yhat1-yhat4
regress lsat age if persnr==1
predict yhat1 if persnr==1
regress lsat age if persnr==2
predict yhat2 if persnr==2
regress lsat age if persnr==3
predict yhat3 if persnr==3
regress lsat age if persnr==4
predict yhat4 if persnr==4

twoway  (scatter lsat1-lsat4 age, msymbol(O O O O) msize(large large large large) mcolor(blue green orange brown))  ///
        (line    yhat1-yhat4 age, lwidth(thick thick thick thick) lcolor(blue green orange brown))                  ///
        (lfit lsat age, lwidth(medthick) lcolor(red)),      ///
        ylabel(0(2)10,  labsize(medlarge) grid angle(0))    ///
		xlabel(25(1)30, labsize(medlarge))                  /// 
		xtitle(Age in Years, size(large) margin(medsmall))  ///
		ytitle(Satisfaction, size(large))                   ///
        legend(off) 


* Comparing FE and RE
xtset persnr time
xtreg lsat age, fe
xtreg lsat age, re theta
